/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logd;

import com.ibm.hwmca.base.logd.EventLogData;
import com.ibm.hwmca.base.logd.EventLogInitTable;
import com.ibm.hwmca.base.logd.LogErrorIdsLogD;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;

public class FileDisplayerBean
extends PanelBean
implements LogErrorIdsLogD {
    private static final transient FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogDisplayer");
    private static final String TRACE_MASKT = "XLOGDBVT";
    private static final String TRACE_MASKF = "XLOGDBVF";
    private static final String TRACE_MASKD = "XLOGDBVD";
    public static final String BEAN_NAME = "FileDisplayerBean";
    public static final String SELECTED_FILES_LIST_NAME = "selectedFilesListName";
    public static final String ZIP_FILE_NAME = "ZipFileName";
    public static final String BUTTON_ZIP = "SaveButton";
    public static final String BUTTON_CANCEL = "CancelButton";
    private transient ItemDescriptor[] m_idEventLogTable;
    private transient ColumnDescriptor[] m_cdEventLogTableStructure;
    private transient int[] m_iEventLogTableSelection;
    private transient ItemDescriptor[] m_idFilesTable;
    private transient ColumnDescriptor[] m_cdFilesTableStructure;
    private transient int[] m_iFilesTableSelection;
    private String[] _fileList;
    private String m_sZipFileNameEdit;
    private transient int _numFiles;
    public static final String ZIP_FILE_NAME_EDIT = "ZipFileNameEdit";
    public static final String FILES_TABLE = "FilesTable";
    private EventLogData _eventLogData;

    public FileDisplayerBean() {
        this.setBeanName(BEAN_NAME);
    }

    public String[] getFileList() {
        return this._fileList;
    }

    public String getZipFileNameEdit() {
        return this.m_sZipFileNameEdit;
    }

    public void setZipFileNameEdit(String zipFileNameEdit) {
        this.m_sZipFileNameEdit = zipFileNameEdit;
    }

    public void setFileList(String[] fileList) {
        this._fileList = fileList;
    }

    public EventLogData getEventLogData() {
        return this._eventLogData;
    }

    public void setEventLogData(EventLogData eventLogData) {
        this._eventLogData = eventLogData;
    }

    public ColumnDescriptor[] getEventLogTableRowStructure() {
        return this.m_cdEventLogTableStructure;
    }

    public int getEventLogTableRowStatus() {
        return 3;
    }

    public int getEventLogTableRowCount() {
        return 1;
    }

    public ItemDescriptor[] getEventLogTableRowAt(int index) {
        return this.m_idEventLogTable;
    }

    public void setEventLogTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idEventLogTable = items;
    }

    public int[] getEventLogTableSelection() {
        return this.m_iEventLogTableSelection;
    }

    public void setEventLogTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iEventLogTableSelection = selected;
    }

    public ColumnDescriptor[] getFilesTableRowStructure() {
        return this.m_cdFilesTableStructure;
    }

    public int getFilesTableRowStatus() {
        return 3;
    }

    public int getFilesTableRowCount() {
        return this._numFiles;
    }

    public ItemDescriptor[] getFilesTableRowAt(int index) {
        this.m_idFilesTable[0].setName("FileNameTable" + index);
        this.m_idFilesTable[0].setTitle(this._fileList[index]);
        return this.m_idFilesTable;
    }

    public void setFilesTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idFilesTable = items;
    }

    public int[] getFilesTableSelection() {
        return this.m_iFilesTableSelection;
    }

    public void setFilesTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iFilesTableSelection = selected;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void load() {
        this.m_cdEventLogTableStructure = new ColumnDescriptor[0];
        this.m_iEventLogTableSelection = new int[0];
        this.m_cdFilesTableStructure = new ColumnDescriptor[0];
        this.m_iFilesTableSelection = new int[0];
        this._numFiles = this._fileList.length;
        Trace.trace(TRACE_MASKF, "NumFileList=" + this._numFiles);
        this.m_idFilesTable = new ItemDescriptor[1];
        this.m_idFilesTable[0] = new ItemDescriptor();
        this.m_idEventLogTable = EventLogInitTable.setEventTableData(this._eventLogData);
    }

    public void panelAction(TaskActionEvent evt) {
        Trace.trace(TRACE_MASKT, "-> FileDisplayerBean.panelAction()");
        PanelTaskletRequest request = null;
        try {
            UserTaskManager utm = (UserTaskManager)evt.getSource();
            utm.storeElement(ZIP_FILE_NAME_EDIT);
            utm.storeElement(FILES_TABLE);
            String command = evt.getActionCommand();
            Trace.trace(TRACE_MASKF, "command = " + command);
            request = new PanelTaskletRequest();
            request.setData("event", evt);
            request.setData("panelName", "FileDisplayerNamePanel");
            Trace.trace(TRACE_MASKF, "Zip file name=[" + this.m_sZipFileNameEdit + "]");
            Integer[] selected = null;
            if (command.equals(BUTTON_ZIP)) {
                Trace.trace(TRACE_MASKF, "View File List - ZIP button selected");
                if (this.m_iFilesTableSelection == null || this.m_sZipFileNameEdit == null || this.m_iFilesTableSelection.length == 0 || this.m_sZipFileNameEdit.length() == 0) {
                    Trace.trace(TRACE_MASKF, "Either there was no zip file OR  there were no files selected - for zip operation.");
                    BaseMessageText myMess = new BaseMessageText("LOGDNSEL");
                    LocalizableText lStrTitle = new LocalizableText(BaseTextBundle.getBundleName(), "logd.file.displayer.title");
                    CommonMsgApp.showMessageBox(this.userTaskManager, lStrTitle, myMess, MsgType.INFORMATION_MESSAGE);
                } else {
                    int numSelected = this.m_iFilesTableSelection.length;
                    selected = new Integer[numSelected];
                    for (int i = 0; i < numSelected; ++i) {
                        selected[i] = new Integer(this.m_iFilesTableSelection[i]);
                    }
                    request.setData(ZIP_FILE_NAME, this.m_sZipFileNameEdit);
                    request.setData(SELECTED_FILES_LIST_NAME, selected);
                    this.postTaskletRequest(request);
                }
            } else {
                this.postTaskletRequest(request);
            }
            Trace.trace(TRACE_MASKT, "<- FileDisplayerBean.panelAction()");
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Error caught in FileDisplayerBean.panelAction() exc = " + e);
            HException he = new HException(e);
            new FrameworkLog(_logInfo, 1304, he).log();
            request.setData("panelError", "terminate");
            this.postTaskletRequest(request);
        }
    }
}

